<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Help-Settings-Schema"
                              xmlns:wwhsettings="urn:WebWorks-Help-Settings-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:wwexec="urn:WebWorks-XSLT-Extension-Execute"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc wwexec"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwhsettings" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:variable name="GlobalSettingsTemplatePath" select="wwuri:AsFilePath('wwformat:Transforms/wwhelp_settings.xml')" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarProgressGroupsAndMergeStart" select="wwprogress:Start(count($VarProjectGroups) + 1)" />

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarProgressGroupStart" select="wwprogress:Start(1)" />

    <!-- Determine group output directory path -->
    <!--                                       -->
    <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarProjectGroup/@Name)" />

    <xsl:variable name="VarGroupFiles" select="$GlobalFiles//wwfiles:File[(@groupID = $VarProjectGroup/@GroupID)]" />
    <xsl:variable name="VarProjectChecksum" select="concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarGroupFiles))" />

    <!-- wwhdata -->
    <!--         -->
    <xsl:call-template name="wwhdata">
     <xsl:with-param name="ParamPath" select="$VarGroupOutputDirectoryPath" />
     <xsl:with-param name="ParamProjectChecksum" select="$VarProjectChecksum" />
     <xsl:with-param name="ParamGroupID" select="$VarProjectGroup/@GroupID" />
     <xsl:with-param name="ParamGroupFiles" select="$VarGroupFiles" />
     <xsl:with-param name="ParamType" select="$ParameterType" />
     <xsl:with-param name="ParamCategory" select="$ParameterCategory" />
     <xsl:with-param name="ParamUse" select="$ParameterUse" />
     <xsl:with-param name="ParamDeploy" select="$ParameterDeploy" />
    </xsl:call-template>

    <!-- wwhelp -->
    <!--        -->
    <xsl:call-template name="wwhelp">
     <xsl:with-param name="ParamPath" select="$VarGroupOutputDirectoryPath" />
     <xsl:with-param name="ParamProjectChecksum" select="$GlobalProject/wwproject:Project/@ChangeID" />
     <xsl:with-param name="ParamGroupID" select="$VarProjectGroup/@GroupID" />
     <xsl:with-param name="ParamType" select="$ParameterType" />
     <xsl:with-param name="ParamCategory" select="$ParameterCategory" />
     <xsl:with-param name="ParamUse" select="$ParameterUse" />
     <xsl:with-param name="ParamDeploy" select="$ParameterDeploy" />
    </xsl:call-template>

    <xsl:variable name="VarProgressGroupEnd" select="wwprogress:End()" />
   </xsl:for-each>

   <!-- Merge -->
   <!--       -->
   <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />
   <xsl:if test="count($VarProjectGroups) &gt; 1">
    <!-- wwhelp -->
    <!--        -->
    <xsl:call-template name="wwhelp">
     <xsl:with-param name="ParamPath" select="wwprojext:GetTargetOutputDirectoryPath()" />
     <xsl:with-param name="ParamProjectChecksum" select="$GlobalProject/wwproject:Project/@ChangeID" />
     <xsl:with-param name="ParamGroupID" select="''" />
     <xsl:with-param name="ParamType" select="$ParameterType" />
     <xsl:with-param name="ParamCategory" select="$ParameterCategory" />
     <xsl:with-param name="ParamUse" select="$ParameterUse" />
     <xsl:with-param name="ParamDeploy" select="$ParameterDeploy" />
    </xsl:call-template>
   </xsl:if>

   <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />

   <xsl:variable name="VarProgressGroupsAndMergeEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="wwhdata">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamProjectChecksum" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamGroupFiles" />
  <xsl:param name="ParamType" />
  <xsl:param name="ParamCategory" />
  <xsl:param name="ParamUse" />
  <xsl:param name="ParamDeploy" />

  <!-- Up-to-date? -->
  <!--             -->
  <xsl:variable name="VarSearchUpToDate" select="wwfilesext:UpToDate(wwfilesystem:Combine($ParamPath, 'wwhdata/js/search.js'), $ParamProjectChecksum, $ParamGroupID, '', $GlobalActionChecksum)" />
  <xsl:if test="not($VarSearchUpToDate)">
   <xsl:variable name="VarResult">
    <!-- Clear search files -->
    <!--                    -->
    <xsl:if test="wwfilesystem:DirectoryExists(wwfilesystem:Combine($ParamPath, 'wwhdata/js/search'))">
     <xsl:variable name="VarIgnoreDeleteDirectory" select="wwfilesystem:DeleteDirectory(wwfilesystem:Combine($ParamPath, 'wwhdata/js/search'))" />
    </xsl:if>

    <!-- WWHelp 5.0 Indexer -->
    <!--                    -->
    <xsl:variable name="VarWWHelp5Path" select="wwuri:AsFilePath('wwhelper:WebWorks/wwhelp5.exe')" />
    <xsl:variable name="VarWWHDataPath" select="wwfilesystem:Combine($ParamPath, 'wwhdata')" />
    <xsl:variable name="VarExecuteResult" select="wwexec:ExecuteCommandInDirectory($ParamPath, $VarWWHelp5Path, '-wwhdata', $VarWWHDataPath)" />

    <!-- Log result -->
    <!--            -->
    <xsl:if test="string-length($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Output']/text()) &gt; 0">
     <xsl:choose>
      <xsl:when test="$VarExecuteResult/wwexec:Result/@retcode = 0">
       <xsl:variable name="VarIgnoreOutput" select="wwlog:Message($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Output']/text())" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:variable name="VarIgnoreOutput" select="wwlog:Warning($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Output']/text())" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
    <xsl:if test="string-length($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Error']/text()) &gt; 0">
     <xsl:variable name="VarIgnoreError" select="wwlog:Warning($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Error']/text())" />
    </xsl:if>
   </xsl:variable>
  </xsl:if>

  <!-- Report Files -->
  <!--              -->
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/common/context.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/common/context.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/common/files.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/common/files.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/common/title.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/common/title.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/common/topics.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/common/topics.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/js/index.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/js/index.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <xsl:variable name="VarSearchFiles" select="wwfilesystem:GetFiles(wwfilesystem:Combine($ParamPath, 'wwhdata/js/search'))" />
  <xsl:for-each select="$VarSearchFiles/wwfiles:Files/wwfiles:File">
   <xsl:variable name="VarSearchFile" select="." />

   <wwfiles:File path="{$VarSearchFile/@path}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum($VarSearchFile/@path)}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  </xsl:for-each>
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/js/search.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/js/search.js'))}" projectchecksum="{$ParamProjectChecksum}" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}">
   <xsl:for-each select="$ParamGroupFiles">
    <xsl:variable name="VarGroupFile" select="." />

    <wwfiles:Depends path="{$VarGroupFile/@path}" checksum="{$VarGroupFile/@checksum}" groupID="{$VarGroupFile/@groupID}" documentID="{$VarGroupFile/@documentID}" />
   </xsl:for-each>
  </wwfiles:File>
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhdata/js/toc.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhdata/js/toc.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
 </xsl:template>


 <xsl:template name="wwhelp">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamProjectChecksum" />
  <xsl:param name="ParamGroupID" />
  <xsl:param name="ParamType" />
  <xsl:param name="ParamCategory" />
  <xsl:param name="ParamUse" />
  <xsl:param name="ParamDeploy" />

  <xsl:variable name="VarBooksUpToDate" select="wwfilesext:UpToDate(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/books.js'), $ParamProjectChecksum, $ParamGroupID, '', $GlobalActionChecksum)" />
  <xsl:variable name="VarMessagesUpToDate" select="wwfilesext:UpToDate(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/locale.js'), $ParamProjectChecksum, $ParamGroupID, '', $GlobalActionChecksum)" />
  <xsl:variable name="VarSettingsUpToDate" select="wwfilesext:UpToDate(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/options.js'), $ParamProjectChecksum, $ParamGroupID, '', $GlobalActionChecksum)" />

  <xsl:if test="not($VarBooksUpToDate) or not($VarMessagesUpToDate) or not($VarSettingsUpToDate)">
   <!-- WWHelp 5.0 Indexer -->
   <!--                    -->
   <xsl:variable name="VarWWHelp5Path" select="wwuri:AsFilePath('wwhelper:WebWorks/wwhelp5.exe')" />
   <xsl:variable name="VarWWHelpPath" select="wwfilesystem:Combine($ParamPath, 'wwhelp')" />
   <xsl:variable name="VarExecuteResult" select="wwexec:ExecuteCommandInDirectory($ParamPath, $VarWWHelp5Path, '-wwhelp', $VarWWHelpPath)" />

   <!-- Log result -->
   <!--            -->
   <xsl:if test="string-length($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Output']/text()) &gt; 0">
    <xsl:choose>
     <xsl:when test="$VarExecuteResult/wwexec:Result/@retcode = 0">
      <xsl:variable name="VarIgnoreOutput" select="wwlog:Message($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Output']/text())" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:variable name="VarIgnoreOutput" select="wwlog:Warning($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Output']/text())" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <xsl:if test="string-length($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Error']/text()) &gt; 0">
    <xsl:variable name="VarIgnoreError" select="wwlog:Warning($VarExecuteResult/wwexec:Result/wwexec:Stream[@name = 'Error']/text())" />
   </xsl:if>
  </xsl:if>

  <xsl:variable name="VarBooksPath" select="wwfilesystem:Combine($ParamPath, 'wwhelp/books.xml')" />
  <xsl:variable name="VarMessagesPath" select="wwfilesystem:Combine($ParamPath, 'wwhelp/messages.xml')" />
  <xsl:variable name="VarSettingsPath" select="wwfilesystem:Combine($ParamPath, 'wwhelp/settings.xml')" />

  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/books.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/books.js'))}" projectchecksum="{$ParamProjectChecksum}" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}">
   <wwfiles:Depends path="{$VarBooksPath}" checksum="{wwfilesystem:GetChecksum($VarBooksPath)}" groupID="{$ParamGroupID}" documentID="" />
  </wwfiles:File>

  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/locale.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/locale.js'))}" projectchecksum="{$ParamProjectChecksum}" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}">
   <wwfiles:Depends path="{$VarMessagesPath}" checksum="{wwfilesystem:GetChecksum($VarMessagesPath)}" groupID="{$ParamGroupID}" documentID="" />
  </wwfiles:File>

  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/options.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/options.js'))}" projectchecksum="{$ParamProjectChecksum}" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}">
   <wwfiles:Depends path="{$VarSettingsPath}" checksum="{wwfilesystem:GetChecksum($VarSettingsPath)}" groupID="{$ParamGroupID}" documentID="" />
  </wwfiles:File>

  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/title.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/common/private/title.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/js/private/locale.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/js/private/locale.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
  <wwfiles:File path="{wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/js/private/options.js')}" type="{$ParamType}" checksum="{wwfilesystem:GetChecksum(wwfilesystem:Combine($ParamPath, 'wwhelp/wwhimpl/js/private/options.js'))}" projectchecksum="" groupID="{$ParamGroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParamCategory}" use="{$ParamUse}" deploy="{$ParamDeploy}" />
 </xsl:template>
</xsl:stylesheet>
